'use strict'

entityRegistry['module']['greetsTags'] = {
    extendedInfo: {
        displayName: 'Greets Tags',
        displayGroup: '3D Effects',
    },
    init: (staticConfig) => {
        return {
        }
    },
    staticConfig: [
        { paramName: 'seed', displayName: 'Seed', type: 'string', defaultValue: 'seed', triggerInit: true },
        { paramName: 'numTags', displayName: 'Num Tags', type: 'int', defaultValue: 20, triggerInit: true },
    ],
    dynamicConfig: [
        { paramName: 'animation', displayName: 'Animation', type: 'float', defaultValue: 0},
        { paramName: 'scale', displayName: 'Scale', type: 'float2', defaultValue: [1, 1]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                seed,
                numTags,
                animation,
                scale,
            } = { ...config }

            const rng = new Math.seedrandom(seed)

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const textureLayer0 = getColorTexture('greets/layer0')
            const textureLayer1 = getColorTexture('greets/layer1')
            const textureGreets = [
                getColorTexture('greets/tags/atebit'),
                getColorTexture('greets/tags/bm'),
                getColorTexture('greets/tags/bps'),
                getColorTexture('greets/tags/desire'),
                getColorTexture('greets/tags/FLT'),
                getColorTexture('greets/tags/holon'),
                getColorTexture('greets/tags/orange'),
                getColorTexture('greets/tags/orb'),
                getColorTexture('greets/tags/purple'),
                getColorTexture('greets/tags/replay'),
                getColorTexture('greets/tags/ribbon'),
                getColorTexture('greets/tags/sonik'),
                getColorTexture('greets/tags/TPOLM'),
                getColorTexture('greets/tags/ukscene'),
            ]
            const textureAspect = textureLayer0.width / textureLayer0.height
            const tY = 1 / textureAspect / 2

            const texCoords = [
                [1,0], [0,0],
                [1,1], [0,1],
            ]
            const tris = [
                [0, 1, 2], [1, 3, 2],
            ]
            const scaleMat = m4.scaling(scale[0], scale[1], 1)

            const colorLayer0 = renderer.getPaletteId([.9,.9,.9],[.9,.9,.9])
            const colorLayer1 = renderer.getPaletteId([0,0,0],[0,0,0])
            const colors = [
                renderer.getPaletteId([.5,.2,.2],[.5,.2,.2]),
                renderer.getPaletteId([.2,.4,.5],[.2,.4,.5]),
                renderer.getPaletteId([.2,.4,.4],[.2,.4,.4]),
                renderer.getPaletteId([.4,.5,.2],[.4,.5,.2]),
            ]

            for (let i = 0; i < numTags; ++i) {
                const layers = [
                    [textureGreets[i%textureGreets.length], colorLayer1],
                    [textureLayer1, colors[i%colors.length]],
                    [textureLayer0, colorLayer0],
                ]
    
                const pX = (rng()-.5)*10
                const pY = (rng()-.5)*20
                const pZ = (rng()-.5)*3
                const actualY = pY + animation*5-10
                const yBlah = -actualY - (rng()-.5)*2
                const rX = yBlah*.2 + (rng()-.5)*.2
                const rY = yBlah*.1 + (rng()-.5)*.2
                const rZ = yBlah*.2 + (rng()-.5)*.2
                const xRotationMat = m4.xRotation(rX)
                const yRotationMat = m4.yRotation(rY)
                const zRotationMat = m4.zRotation(rZ)
                const rotationMat = m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat)

                if (actualY > -4.5 && actualY < 4.5) {
                    const translationMat = m4.translation(pX, actualY, pZ)
                    const worldMat = m4.multiply(translationMat, m4.multiply(rotationMat, scaleMat))

                    for (let i = 0; i < layers.length; ++i) {
                        const z = i * -.000001
                        const transformedVerts = renderer.transformVerts(worldMat, [
                            [-.5, -tY, z], [+.5, -tY, z],
                            [-.5, +tY, z], [+.5, +tY, z],
                        ])

                        tris.forEach(tri => {
                            renderer.clipDrawTri_Cull_Depth_Textured(
                                colorBuffer.data,
                                depthBuffer.data,
                                brightnessBuffer.data,
                                transformedVerts[tri[0]],
                                transformedVerts[tri[1]],
                                transformedVerts[tri[2]],
                                texCoords[tri[0]],
                                texCoords[tri[1]],
                                texCoords[tri[2]],
                                layers[i][0],
                                layers[i][1],
                                1
                            )
                        })
                    }
                }
            }
        }
    }
}
